/*jslint node: true, nomen: true, unparam: true */
/*global jquery, $, _, define, Marionette, Handlebars, jqm, describe, it, expect, beforeEach, spyOn */

define([ 'Portal', 'backbone', 'marionette', 'jquery', 'underscore', 'jquerymobile', 'jquerymobile-autocomplete', 'moment',
    'hbs!applets/wound-care-applet/core/extensions/list-generator/core/views/patients/PatientList',
    'hbs!applets/wound-care-applet/core/extensions/list-generator/core/views/patients/patientListHeader',
    'applets/wound-care-applet/core/extensions/list-generator/core/views/AutocompleteListView',
    'applets/wound-care-applet/core/extensions/list-generator/core/views/patients/PatientView'],
    function (Portal, Backbone, Marionette, $, _, jqm, jqmAutocomplete, moment, template, templateHeader, AutocompleteListView) {
        'use strict';
        var self;
        return Portal.module('ListGenerator', function (ListGenerator, Portal, Backbone, Marionette, $, _, template, templateHeader) {
            ListGenerator.PatientListView = AutocompleteListView.extend({
                itemView: ListGenerator.PatientView,
                events: {
                    'input .ui-accessible-autocomplete-filter input': 'setPatientFilterText',
                    'change .ui-accessible-autocomplete-filter input': 'setPatientFilter',
                    'tap .ui-accessible-autocomplete-filter a.ui-input-clear': 'clearPatientFilter',
                    'tap ul a': 'preventDefault',
                    'keyup ul a': 'keyupList'
                },
                collectionEvents: {
                    'sync': 'refreshAutocomplete',
                    'reset': 'refreshAutocomplete'
                },
                initialize: function(options) {
                    self = this;
                    this.placeholder = "Search Patient By Name or SSN...";
                    this.noItemsMessage = "No Results Found";
                    this.minLength = 3;
                    this.onSubmit = true;

                    if ( typeof options !== 'undefined' ) {
                        this.placeholder = options.placeholder || this.placeholder;
                        this.minLength = options.minLength || this.minLength;
                        this.onSubmit = options.onSubmit || this.onSubmit;
                    }
                },
                onRender: function () {
                    var type = this.model.get('type'),
                        autocompleteCallback = this._autocomplete();

                    this.ui.autocompleteList.accessibleautocomplete({
                        'populateList': autocompleteCallback.populateList,
                        'selectItem': autocompleteCallback.selectItem,
                        'filterItem': autocompleteCallback.filterItem,
                        'filterPlaceholder': self.placeholder,
                        'filterNoItemsMessage': self.noItemsMessage,
											'filterOnPopulateList': true,
											'filterSubmit': this.onSubmit,
                        'filterMinLength': self.minLength,
                        'filterReveal': false,
                        'inset': true,
                        'splitIcon': 'star'
                    });
                    this.$el.trigger('create');
                    this.$el.find('.ui-accessible-autocomplete-filter input').val( this.model.get('patientFilter') );
                    this.doBasedOnType();
                },
                onClose: function () {
                    $('#portal-modal .ui-content').off('scrollstop');
                    this.stopListening();
                    this.off();
                },
                setPatientFilterText: function(e) {
                    var patientFilter = $(e.currentTarget).val();

                    if ( this.model.get('patientFilter') !== patientFilter ) {
                        this.model.set( 'patientFilter', patientFilter );
                        if (patientFilter === "") {
                            this.doBasedOnType();
                        }
                    }
                },
                setPatientFilter: function(e) {
                    var activeLiAnchor = this.ui.autocompleteList.find('li.ui-btn-down-d a'),
                        patientFilter = this.model.get('patientFilter').toUpperCase(),
                        liIndex;

                    if (activeLiAnchor.length === 0) {
                        if (this.ui.autocompleteList.find('li:not(.ui-screen-hidden, .ui-li-static)').length > 0) {
                            // switch to _.findIndex after updating to lodash 2.4.1
                            _.find(this.collection.models, function(patient, index) {
                                if (patient.get('displayName').toUpperCase() === patientFilter) {
                                    liIndex = index + 1;
                                    return true;
                                }
                            });
                        }
                    } else {
                        activeLiAnchor.tap();
                    }
                },
                clearPatientFilter: function(e) {
                    e.preventDefault();
                    this.model.set( 'patientFilter', "" );
                    this.doBasedOnType();
                },
                fetchPage: function(e) {
                    var nextPage = this.collection.latestPage + 1,
                        size = this.collection.results,
                        totalResults = this.collection.totalResults,
                        atEndOfPage = e.currentTarget.scrollHeight - e.currentTarget.scrollTop <= e.currentTarget.clientHeight + 100;

                    if ( atEndOfPage && size < totalResults ) {
                        //var data = _.extend({page: nextPage}, this._autocomplete().fetchData());
                        var data = this._autocomplete().fetchData() + "page=" + nextPage;

                        this.collection.fetch({
                            url: self.collection.url() + data,
                            remove: false,
                            dataType: "json",
                            //data: data
                        })
                            .done( function ( response ) {
                                // patients appended by Marionette
                                //if (self._isRendered) { self.renderHeader(); }
                            });
                    } else if ( size === totalResults ) {
                        $('#portal-modal .ui-content').off('scrollstop');
                        this.hasPaging = false;
                    }
                },
                doBasedOnType: function () {
                    switch (this.model.get('id')) {
                        case 'wards':
                        case 'clinics':
                            this._autocomplete().bootstrapPrepopulate();
                            return;
                        default:
                            this.collection.reset();
                            //this.clearHeader();
                    }
                },
                // Marionette-1.1.0 doesn't buffer, workaround until we switch to 1.4.0
                // renderHeader: function () {
                //     /* jshint ignore:start */
                //     var header = Handlebars.compile( templateHeader({
                //         size: this.collection.results,
                //         totalResults: this.collection.totalResults
                //     }) );
                //     /* jshint ignore:end */

                //     this.clearHeader();
                //     this.getItemViewContainer(this).prepend(header);
                //     this.ui.autocompleteList.accessibleautocomplete('refresh');
                // },
                // clearHeader: function () {
                //     this.getItemViewContainer(this).find('.ui-li-divider').remove();
                // },
                _autocomplete: function() {

                    var self = this,
                        hasPaging = false,
                        headerCount = 0, //(typeof templateHeader !== "undefined") ? 1 : 0,

                        fetchData = function(){
                            var data = {},
                                searchValue = self.$el.find('.ui-listview-filter input').val() || "",
                                searchType = self.model.get('id'),
                                location,
                                startDate;

                            if (searchValue.trim() !== "") {
                                data.searchstring = encodeURIComponent( searchValue.trim() );
                            }

                            if ( self.model.has('location') ) {
                                location = self.model.get('location');

                                if (searchType === 'clinics') {
                                    data.clinic = location.get('id');

                                    startDate = self.model.get('dateFilter');
                                    if (startDate !== "") {
                                        data.visitDate = moment(startDate).format('YYYYMMDD');
                                    }
                                } else if (searchType === 'wards') {
                                    data.ward = location.get('id');
                                }
                            }
                            // return data;
                            var dataString = "?";
                            _.forEach(_.keys(data), function(key) {
                                dataString += key + "=" + data[key] + "&";
                            });
                            return dataString;
                        },

                        bootstrapPrepopulate = function () {
                            var data = fetchData();
                            self.ui.autocompleteList.accessibleautocomplete( 'option', 'filterNoItemsMessage', self.noItemsMessage );

                            self.collection.fetch({
                                url: self.collection.url() + data,
                                dataType: "json",
                                //data: data
                            })
                                .done( function ( response ) {
                                    //if (self._isRendered) { self.renderHeader(); }

                                    if ( !hasPaging ) {
                                        $('#portal-modal .ui-content').on('scrollstop', function(e) {
                                            self.fetchPage(e);
                                        });
                                        hasPaging = true;
                                    }
                                })
                                .fail( function ( jqXHR ) {
                                    self.collection.reset();

                                    if (jqXHR.status === 400) {
                                        list.accessibleautocomplete( 'option', 'filterNoItemsMessage', $.parseJSON(jqXHR.responseText).message );
                                        hasPaging = false;
                                    }
                                });

                        },

                        populatePatientSearch = function (deferred, searchValue, list) {
                            var data = fetchData();
                            list.accessibleautocomplete( 'option', 'filterNoItemsMessage', self.noItemsMessage );

                            self.collection.fetch({
                                url: self.collection.url() + data,
                                dataType: "json",
                                //crossDomain: true,
                                //data: data
                            })
                                .done( function ( response ) {
                                    //self.renderHeader();

                                    // patients appended by Marionette
                                    if ( !hasPaging ) {
                                        $('#portal-modal .ui-content').on('scrollstop', function(e) {
                                            self.fetchPage(e);
                                        });
                                        hasPaging = true;
                                    }
                                    // selects first link in list
                                    self.$el.find('ul a').eq(0).focus();
                                    return deferred.resolve();
                                })
                                .fail( function ( jqXHR ) {
                                    self.collection.reset();

                                    if (jqXHR.status === 400) {
                                        list.accessibleautocomplete( 'option', 'filterNoItemsMessage', $.parseJSON(jqXHR.responseText).message );
                                        hasPaging = false;
                                    }

                                    return deferred.resolve();
                                });

                            return deferred.promise();
                        },

                        showConfirmation = function ( search, item ) {
                            var patient = self.collection.at(item.index() - headerCount);

                            ListGenerator.model.get('patient').set(patient.attributes);
                            ListGenerator.vent.trigger( "open:popup:confirmation", {positionTo: item} );
                        },

                        filterItem = function ( text, searchValue, item ) {
                            return false; // leave filtering to server
                        };

                    return {
                        fetchData: fetchData,
                        bootstrapPrepopulate: bootstrapPrepopulate,
                        populateList: populatePatientSearch,
                        selectItem: showConfirmation,
                        filterItem: filterItem
                    };
                }
            });
        }, template, templateHeader);
    });
